<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:strip-space elements="*"/>
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads/GeometryProject">
                    <xsl:text/>
                    <xsl:text>* BENTLEY VÝŠKOVÉ ŘEŠENÍ PŘEHLED&#xd;</xsl:text>
                    <xsl:text>* &#xd;</xsl:text>
                    <xsl:for-each select="HorizontalAlignment/VerticalAlignment">
                        <xsl:text>* Název trasy: </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>* Popis trasy: </xsl:text><xsl:value-of select="@description"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>* Styl trasy: </xsl:text><xsl:value-of select="@style"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>* &#xd;</xsl:text>
                        <xsl:value-of select="cif:columnFormat('STANIČENÍ',70)"/>
                        <xsl:value-of select="cif:columnFormat('VÝŠKA',20)"/>
                        <xsl:for-each select="VerticalElements">
                            <xsl:text>&#xd;</xsl:text>
                            <xsl:apply-templates/>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="VerticalLine">
        <xsl:text>Prvek: Přímá</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalStart/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalStart/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:value-of select="cif:columnFormat('StanPuv',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
            <xsl:value-of select="cif:columnFormat('StanNove',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalEnd/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalEnd/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Sklon tečny:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@grade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Délka tečny:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@length)),20)"/>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="VerticalSymmetricalParabola">
        <xsl:text>Prvek: Parabola symetrická</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalStart/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalStart/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(PVI/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PVI/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:value-of select="cif:columnFormat('StanPuv',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
            <xsl:value-of select="cif:columnFormat('StanNove',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation)),20)"/>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalEnd/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalEnd/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="TurningPoint">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(TurningPoint/@pointType)),50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName)),20)"/>
            <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(TurningPoint/@elevation)),20)"/>
        </xsl:if>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Délka:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@verticalCurveLength)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Vstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@startGrade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@endGrade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('r = (g2 - g1) / L:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@rateOfChange)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('K = l / (g2 - g1):',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@kValue)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Střední pořadnice:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@midOrdinate)),20)"/>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="VerticalUnsymmetricalParabola">
        <xsl:text>Prvek: Parabola nesymetrická</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalStart/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalStart/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(PVI/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PVI/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(PVCC/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(PVCC/station/@externalStation), string(PVCC/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PVCC/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:value-of select="cif:columnFormat('StanPuv',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
            <xsl:value-of select="cif:columnFormat('StanNove',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalEnd/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalEnd/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="TurningPoint">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(TurningPoint/@pointType)),50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName)),20)"/>
            <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(TurningPoint/@elevation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat('Vstupní délka:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@startVerticalCurveLength)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní délka:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@endVerticalCurveLength)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Vstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@startGrade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@endGrade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('r = (g2 - g1) / L:',50)"/>
        <xsl:variable name="startRateOfChange">
            <xsl:text>Vstupní:&#xa0;</xsl:text>
            <xsl:value-of select="cif:distanceFormat(number(@startRateOfChange))"/>
        </xsl:variable>
        <xsl:variable name="endRateOfChange">
            <xsl:text>Výstupní:&#xa0;</xsl:text>
            <xsl:value-of select="cif:distanceFormat(number(@endRateOfChange))"/>
        </xsl:variable>
        <xsl:value-of select="cif:columnFormat(string($startRateOfChange),20)"/>
        <xsl:value-of select="cif:columnFormat(string($endRateOfChange),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:variable name="startKValue">
            <xsl:text>Vstupní:&#xa0;</xsl:text>
            <xsl:value-of select="cif:distanceFormat(number(@startKValue))"/>
        </xsl:variable>
        <xsl:variable name="endKValue">
            <xsl:text>Výstupní:&#xa0;</xsl:text>
            <xsl:value-of select="cif:distanceFormat(number(@endKValue))"/>
        </xsl:variable>
        <xsl:value-of select="cif:columnFormat('K = l / (g2 - g1):',50)"/>
        <xsl:value-of select="cif:columnFormat(string($startKValue),20)"/>
        <xsl:value-of select="cif:columnFormat(string($endKValue),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Střední pořadnice:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@midOrdinate)),20)"/>
       <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="VerticalCircle">
        <xsl:text>Prvek: Kruhový oblouk</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalStart/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalStart/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(PVI/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PVI/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalCenter/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalCenter/station/@externalStation), string(VerticalCenter/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalCenter/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:value-of select="cif:columnFormat('StanPuv',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
            <xsl:value-of select="cif:columnFormat('StanNove',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalEnd/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalEnd/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="TurningPoint">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(TurningPoint/@pointType)),50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName)),20)"/>
            <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(TurningPoint/@elevation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat('Poloměr:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@radius)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Délka:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@length)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Vstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@startGrade)),20)"/>
         <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@endGrade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="VerticalClothoid">
        <xsl:text>Prvek: Klotoida</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalStart/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalStart/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(PVI/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PVI/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:value-of select="cif:columnFormat('StanPuv',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
            <xsl:value-of select="cif:columnFormat('StanNove',50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(VerticalEnd/@pointType)),50)"/>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(VerticalEnd/@elevation)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="TurningPoint">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(TurningPoint/@pointType)),50)"/>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName)),20)"/>
            <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(TurningPoint/@elevation)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat('Vstupní poloměr:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@startRadius)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní poloměr:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@endRadius)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Délka:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@length)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Úhel:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:angularFormat(number(@thetaAngle)),20)"/>
            <xsl:if test="@rotationDirection='cw'"><xsl:text> Vpravo</xsl:text></xsl:if>
            <xsl:if test="@rotationDirection = 'ccw'"><xsl:text> Vlevo</xsl:text></xsl:if>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Dlouhá tečna Xm:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@longTangent)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Krátká tečna St:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@shortTangent)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Dlouhá tětiva:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@longChord)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('X:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@xs)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Y:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@ys)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('dR:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@p)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Xs:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@ks)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Vstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@startGrade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní sklon:',50)"/>
        <xsl:value-of select="cif:columnFormat(cif:gradeFormat(number(@endGrade)),20)"/>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
        <xsl:text>    Pro tento výpis musíte vybrat nejméně &#xd;</xsl:text>
        <xsl:text>    jeden Civil prvek výškové geometrie.&#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2012 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>

